<?php
   // Settings for albums

   // Number of images per row; use cols=X in URL to override
   // For irregular grids: number of smallest thumbs per row
   if(isset($_GET['cols']))
      $albumConfig['numCols'] = $_GET['cols'];
   else
      $albumConfig['numCols'] = 5;

   // Show title on top of page? Override with title={no|yes}
   if(isset($_GET['title']))
      $albumConfig['showTitle'] = ($_GET['title'] != "no");
   else
      $albumConfig['showTitle'] = true;

   // If set, this string is prefixed to all album captions
   $albumConfig['albumPrefix'] = "";
   
   // If not set or false, do not show umber of images in a sub-album
   $albumConfig['showCount'] = true;
   
   // File name to use for image captions
   $albumConfig['infoFile']  = "album.info";

   // If set, use this file to expand album aliases
   $albumConfig['aliasFile'] = "/shared/media/photos/album.aliases";

   // When using an alias file, should only aliases be allowed
   // (i.e. album may not be a directory name anymore)
   $albumConfig['aliasesOnly'] = false;

   // When set, allow editing of captions and rating by adding &edit=<value>
   // to the URL
   $albumConfig['editCode'] = "allowed";

   // Size medium size images
   $albumConfig['mWidth']    = 800;
   $albumConfig['mHeight']   = 600;

   // Should all images fit in medium size (i.e. portrait too?)
   $albumConfig['mediumStrict'] = true;

   // URL for CSS file to use
   $albumConfig['cssURL']    = "http://www.ozuzo.net/e-pa/e-pa.css";

   // Allowed image suffixes
   $albumConfig['imgSuffix'] = array("jpg", "jpeg", "gif", "png");

   // What to do with ratings (nothing, selector, irregular grid);
   //  - can be OR'ed together using | symbol
   define("RATING_IGNORE",   0);
   define("RATING_SELECTOR", 1);
   define("RATING_SIZES",    2);

   $albumConfig['ratingAction'] = RATING_SELECTOR;

   // For irregular grids, size of thumbs to use (PX is width for panoramas)
   $albumConfig['thumbSizes'] = array(
                                       //      X,  PX,   Y
                                       array( 47, 110,  35),
                                       array(133, 310, 100),
                                       array(220, 510, 165),
                                       array(300, 700, 225));

   // If set, allow slideshow, with value as interval in milliseconds
   $albumConfig['slideShow'] = 5000;

   // For the mimgs.php script (include trailing slash):
   $albumConfig['srcBase'] = "/shared/media/photos/Raw/";
   $albumConfig['dstBase'] = "/shared/media/photos/";

   // Maximum size main image in the mimgs interface
   $albumConfig['mimgsWidth']    = 1024;
   $albumConfig['mimgsHeight']   = 768;

   // Should jpegtran -optimize be used to strip EXIF data from the
   // copied images? This will significantly reduce generated thumbnail
   // sizes. PATH_JPEGTRAN needs to be defined when set to true.
   $albumConfig['optimizeOnCopy'] = true;

   // Paths to various external programs
   define(PATH_THUMB,    "/usr/local/bin/thumb");
   define(PATH_MONTAGE,  "/usr/X11R6/bin/montage");
   define(PATH_CONVERT,  "/usr/X11R6/bin/convert");
   // Set to "" if convert should be used to rotate images.
   define(PATH_JPEGTRAN, "/usr/bin/jpegtran");
?>
