<?php

// If we are running an old PHP, simulate the following functions

if(!function_exists("dgettext"))
{
   function dgettext($d, $m) { return $m; };
}

if(!function_exists("_"))
{
   function _($m) { return $m; };
}

if(isset($_SESSION['epa']))
{
   require_once("support.php");
}

// Display document header and title

function displayHeader($title = null, $titleAsH1 = true)
{
   global $albumConfig;

   echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">";
   echo "<html><head>";
   if(!is_null($title))
      echo "<title>$title</title>";
   echo "<link rel='stylesheet' type='text/css' href='{$albumConfig['cssURL']}' />";
   if(isset($albumConfig['slideShow']) && !isset($albumConfig['staticLevel']))
   {
      echo "<script language='javascript'>";
      $js = join('', file(dirname(__FILE__) . "/slideshow.js"));
      echo str_replace("__SLIDETIMEOUT__", $albumConfig['slideShow'], $js);
      echo "</script>";
   }
   echo "</head><body";
   if(isset($albumConfig['slideShow']))
   {
      if(isset($albumConfig['staticLevel']))
         echo " onload='if(parent.init) parent.init(); else document.form.slideshow.disabled = true'";
      else
         echo " onload='slide()'";
   }
   echo "><form name='form' method='post' action='{$_SERVER['PHP_SELF']}";
   if(isset($_SERVER['QUERY_STRING']))
      echo "?{$_SERVER['QUERY_STRING']}";
   echo "'>";

   if(isset($albumConfig['slideShow']))
      echo "<table border='0' cellspacing='0' cellpadding='0' width='100%'><tr><td nowrap>";
   if(!is_null($title) && $titleAsH1)
      echo "<h1>$title</h1>";
   if(isset($albumConfig['slideShow']))
   {
      echo "</td><td align='right' nowrap>";
      $checked = (isset($_GET['slide']) && $_GET['slide'] == "on") ? "checked" : "";
      echo "<span class='albumslideshow'><input type='checkbox' class='checkbox' $checked";
      if(isset($albumConfig['staticLevel']))
         echo " onclick='if(parent.slide) parent.slide()'";
      else
         echo " onclick='slide()'";
      echo " name='slideshow'>" . _("slideshow") . "</span>";
      echo "</td></tr></table>";
   }
}

// If in edit mode, add an 'update captions' button

function displayFooter()
{
   global $editMode, $albumConfig;

   if($editMode)
      echo "<tr><td colspan='{$albumConfig['numCols']}' align='right'><p><input type='submit' class='button' value='" . dgettext("album", "update") . "'></td></tr>";
}

function albumHREF($isAlbum, $args = null)
{
   global $albumConfig, $showRating;
   $script = $isAlbum ? "album.php" : "image.php";

   if(isset($albumConfig["staticLevel"]))
   {
      if($isAlbum)
      {
         $p = ($albumConfig['ratingAction'] & RATING_SELECTOR && ($showRating > 1 || $args["size"] > 0)) ? "-{$showRating}" : "";
         $s = ($args["size"] == 0) ? "" : "-{$args['size']}";

         $img = basename($args["image"]);
         $r = ($args["size"] < 2 ? "{$img}/" : "") . "index{$p}{$s}.html";
      }
      else if(strpos($args["image"], "album.jpg"))
         $r = basename(dirname(dirname($args["image"]))) . "/album.jpg";
      else
      {
         $img = basename($args["image"]);
         $p = strrpos($img, ".");
         $name = substr($img, 0, $p);

         switch($args["size"])
         {
         case 0:
            $r = "{$img}/thumbs/{$name}.jpg";
            break;
         case 1:
            $r = "thumbs/medium/{$name}.jpg";
            break;
         case 2:
            $r = $img;
            break;
         }
      }

      // Remove any multiple slashes that might have crept in
      return preg_replace("#/+#", "/", $r);
   }
   else if(!isset($_SESSION['epa']))
      $url = $script . (is_null($args) ? "" : "?");
   else // e-pa
      $url = returnHREF("album/{$script}") . "&";

   if($isAlbum && isset($albumConfig['slideShow']))
      // OK - give all elements to the JavaScript function as somehow someone is unescaping & signs in image names...
      return "javascript:jump(\"{$url}\",\"{$args['album']}\",\"{$args['image']}\",\"{$args['size']}\",\"{$args['refer']}\")";
   else
   {
      foreach($args as $name => $val)
         $url .= $name . "=" . urlencode($val) . "&";
      return $url;
   }
}

// Display a hyperlink in a table cell

function displayLink($class, $label = null, $album = null, $image = null, $size = null, $referOrAlbum = "")
{
   global $albumConfig, $showRating;

   echo "<td width='33%' nowrap class='album$class'>";

   if(is_null($album))
      echo "&nbsp;";
   else
   {
      if(isset($albumConfig["staticLevel"]))
      {
         $s = ($size == 0 ? "" : "-{$size}");
         $p = ($albumConfig['ratingAction'] & RATING_SELECTOR && ($showRating > 1 || $size > 0)) ? "-{$showRating}" : "";
         if($class == "up")
            $href = "../index{$p}{$s}.html";
         else
            $href = "../{$image}/index{$p}{$s}.html";

         echo "<a onmouseover='window.status=\"\";return true' href='{$href}'>$label</a>";
      }
      else
      {
         if($album == ".")
         {
            $album = $image;
            $image = "";
         }

         if(!isset($albumConfig["staticLevel"]) && $class == "up")
         {
            $r = "";
            for($a = "$album/$image"; $a != "."; $a = dirname($a))
            {
               $h = " / <a ";
               if($r == "")
                  $h .= "id='up' ";
               $h .= "onmouseover='window.status=\"\";return true' href='" . albumHREF(true, array("album" => $a, "size" => $size, "refer" => $referOrAlbum)) . "'>" . basename($a) . "</a>";
               $r = $h . $r;
            }
            echo $r;
         }
         else
         {
            echo "<a ";
            if(!$referOrAlbum)
               echo "id='{$class}' ";
            echo "onmouseover='window.status=\"\";return true' href='" . albumHREF(true, array("album" => $album, "image" => $image, "size" => $size)) . "'>$label</a>";
         }
      }
   }
   echo "</td>";
}

// Display previous, next and up links
function displayPrevNext($allowUp, $albumAlias, $file, $iniFile, $isAlbumPage)
{
   global $albumConfig, $showRating;

   if(!is_null($iniFile))
   {
      $base = basename($file);
      $files = $iniFile->getSections();

      $base = array_search($base, $files);
      $cnt = count($files);
      for($next = $base + 1; $next < $cnt; $next++)
         if($showRating == 1 || $iniFile->valueExists($files[$next], 'album') || ($iniFile->valueExists($files[$next], 'rating') && $iniFile->getValue($files[$next], 'rating') >= $showRating))
            break;

      for($prev = $base - 1; $prev >= 0; $prev--)
         if($showRating == 1 || $iniFile->valueExists($files[$prev], 'album') || ($iniFile->valueExists($files[$prev], 'rating') && $iniFile->getValue($files[$prev], 'rating') >= $showRating))
            break;
   }
   echo "<div style='text-align: center'><table border='0' width='100%' cellspacing='0' cellpadding='0' >";
   echo "<tr class='albumrow'>";
   if(isset($prev) && $prev >= 0)
      displayLink("prev", dgettext("album", "previous"), $albumAlias, $files[$prev], $iniFile->valueExists($files[$prev], 'album') ? 0 : 1);
   else
      displayLink("prev", dgettext("album", "previous"));

   if($allowUp)
      displayLink("up", dgettext("album", "album"), dirname($albumAlias), basename($albumAlias), 0, basename($file));
   else
      displayLink("up", dgettext("album", "album"));

   if(isset($next) && $next < $cnt)
      displayLink("next", dgettext("album", "next"), $albumAlias, $files[$next], $iniFile->valueExists($files[$next], 'album') ? 0 : 1, $isAlbumPage);
   else
      displayLink("next", dgettext("album", "next"));
   echo "</tr></table></div>";
}

// Display an image with a border

function displayImageTag($img, $alt, $width, $height, $size, $rating = 0, $clickURL = "", $isImage = true, $id = "")
{
   global $albumConfig;

   // If a directory, use the album thumb from that directory
   if($isImage)
      $imgURL = albumHREF(false, array("image" => $img, "size" => $size, "rating" => $rating));
   else
      $imgURL = albumHREF(false, array("image" => "{$img}/thumbs/album.jpg", "size" => 2, "rating" => 2));

   // The URL for the border images: direct link if not running as e-pa plugin
   if(isset($_SESSION['epa']))
      $bURL = "image.php?album/";
   else if(isset($albumConfig['staticLevel']))
      $bURL = $albumConfig['staticLevel'];
   else
      $bURL = "";

   // Use small borders for thumbnails
   $bPrefix = ($size == 0 ? "2" : "");
   $bS1 = ($size == 0 ? 9 : 18);
   $bS2 = ($size == 0 ? 7 : 14);

   echo "<nobr><img src='{$bURL}images/{$bPrefix}border-tl.gif' width='{$bS1}' height='{$bS2}'  alt='' border='0'>";
   echo "<img src='{$bURL}images/{$bPrefix}border-t.gif'  width='$width' height='{$bS2}' alt='' border='0'>";
   echo "<img src='{$bURL}images/{$bPrefix}border-tr.gif' width='{$bS1}' height='{$bS2}'  alt='' border='0'></nobr><br>";
   echo "<nobr><img src='{$bURL}images/{$bPrefix}border-l.gif' width='{$bS1}' height='$height' alt='' border='0'>";
   if($clickURL != "") echo "<a onmouseover='window.status=\"\";return true' href='$clickURL'>";
   echo "<img src='$imgURL' alt='$alt' border='0' $id width='$width' height='$height'>";
   if($clickURL != "") echo "</a>";
   echo "<img src='{$bURL}images/{$bPrefix}border-r.gif' width='{$bS1}' height='$height' alt='' border='0'></nobr><br>";
   echo "<nobr><img src='{$bURL}images/{$bPrefix}border-bl.gif' width='{$bS1}' height='{$bS1}' alt='' border='0'>";
   echo "<img src='{$bURL}images/{$bPrefix}border-b.gif' width='$width' height='{$bS1}' alt='' border='0'>";
   echo "<img src='{$bURL}images/{$bPrefix}border-br.gif' width='{$bS1}' height='{$bS1}' alt='' border='0'></nobr><br>";
}

// Display an (clickable) image with its caption and a border in a table cell

function displayImage($albumAlias, $image, $caption, $alt, $width, $height, $size, $colspan = 1, $rowspan = 1, $isImage = true, $imgID = null, $needEdit = false, $rating = -1)
{
   global $editMode, $albumConfig, $albumName;

   $class = "albumcell" . ($needEdit ? "-edit" : "") . ($rating > 0 ? "-rating-{$rating}" : "");
   echo "<td class='$class' colspan='$colspan' rowspan='$rowspan' valign='top'>";

   // If showing a smaller size image, add an hyperlink to the next bigger size
   if($size < 2)
   {
      $nextSize = $isImage ? ($size + 1) : $size;
      $clickURL = albumHREF(true, array("album" => $albumAlias, "image" => $image, "size" => $nextSize));
   }
   else
      $clickURL = "";

   $id = is_null($imgID) ? "" : "id='i_{$imgID}'";

   // Display the image and its borders
   displayImageTag("{$albumName}/{$image}", $alt, $width, $height, $size, $albumConfig['ratingAction'] & RATING_SIZES ? $rowspan : 0, $clickURL, $isImage, $id);

   if($editMode)
   {
      $idx = basename($image);
      echo "<input class=albumedit type=text style='width: 100%' name='captions[{$idx}]' value='" . htmlspecialchars(stripslashes($caption), ENT_QUOTES) . "'>";

      if($rating > -1)
      {
         echo "<div style='text-align: left'>" . dgettext("album", "Rating") . ": <select name='rating[{$idx}]'>";
         for($i = 0; $i <= 4; $i++)
         {
            echo "<option value=$i";
            if($i == $rating) echo " selected";
            echo ">" . ($i == 0 ? "none" : $i);
         }
         echo "</div>";
      }
   }
   else
   {
      $id = is_null($imgID) ? "" : "id='{$imgID}'";

      if($clickURL != "") echo "<a $id onmouseover='window.status=\"\";return true' href='$clickURL'>";
      echo stripslashes($caption);
      if($clickURL != "") echo "</a>";
   }
   echo "</td>";
}

// Display an HTML page for a (sub)album

function displayAlbum($iniFile, $albumAlias, $albumName, $allowSide, $writeCaptionDir, $forceCaptionWrite = null)
{
   global $albumConfig, $showRating;

   $writeCaptions = false;

   // Get all files in there
   $handle = @opendir($albumName);
   while($file = @readdir($handle))
   {
      $dotpos = strrpos($file, ".");
      $isSubAlbum = (is_dir("{$albumName}/{$file}") && $file != "thumbs" && $file[0] != ".");

      // If image or subalbum
      if($isSubAlbum || in_array(strtolower(substr($file, $dotpos+1)), $albumConfig['imgSuffix']))
      {
         if(!$iniFile->sectionExists($file))
         {
            // Add to ini file new file
            $writeCaptions = true;
            $iniFile->setValue($file, "caption", $isSubAlbum ? $file : substr($file, 0, $dotpos));
            if($isSubAlbum)
               $iniFile->setValue($file, "album", true);
         }
      }
   }
   @closedir($handle);

   // Save posted captions
   if(isset($_POST['captions']))
   {
      while(list($file, $caption) = each($_POST['captions']))
         $iniFile->setValue($file, 'caption', $caption);
      $writeCaptions = true;
   }

   // Save posted ratings
   if(isset($_POST['rating']))
   {
      $files = $iniFile->getSections();
      foreach($files as $file)
      {
         $oldRating = $iniFile->valueExists($file, 'rating') ? $iniFile->getValue($file, 'rating') : 0;
         $newRating = isset($_POST['rating'][$file]) ? $_POST['rating'][$file] : 0;

         if($oldRating != $newRating)
         {
            $writeCaptions = true;
            if($albumConfig['ratingAction'] & RATING_SIZES)
            {
               // Remove thumb to force re-create
               if($iniFile->valueExists($file, 'album'))
                  @unlink("{$albumName}/{$file}/thumbs/album.jpg");
               else
                  @unlink("{$albumName}/thumbs/{$file}");
            }
         }

         if($newRating > 0)
            $iniFile->setValue($file, 'rating', $newRating);
         else
            unset($iniFile->results[$file]['rating']);
      }
   }

   // TODO: remove non-existing files

   if($albumConfig['showTitle'])
      displayHeader(sprintf(dgettext("album", "%s album"), basename($albumName)));
   else
      displayHeader();

   if($iniFile->valueExists("Album", "caption"))
      echo "<div>" . $iniFile->getValue("Album", "caption") . "</div>";

   $files = $iniFile->getSections();

   $upInfo = dirname($albumName) . "/{$albumConfig['infoFile']}";
   displayPrevNext(is_file($upInfo),
                   dirname($albumAlias),
                   basename($albumName),
                   $allowSide ? new IniFile($upInfo) : null,
                   true);

   echo "<div style='text-align: center'><table cellspacing='0' cellpadding='0' width='100%'><tr><td width='50%'></td><td><table border='0' cellspacing='0' cellpadding='0' class='albumtable'>";
   echo "<tr class='albumrow'>";

   if($albumConfig['ratingAction'] & RATING_SIZES)
      displayIrregularGrid($files, $iniFile);
   else
      displayRegularGrid($files, $iniFile);

   if($albumConfig['ratingAction'] & RATING_SELECTOR)
   {
      echo "<tr><td colspan='{$albumConfig['numCols']}' align='right'>" . dgettext("album", "Show rated images") . ": ";
      echo "<select name='showRating' ";

      if(isset($albumConfig["staticLevel"]))
         echo "onChange='window.location=\"index\" + (this.value > 1 ? (\"-\" + this.value) : \"\") + \".html\"'>";
      else
         echo "onChange='form.submit(this)'>";
      for($i = 1; $i <= 4; $i++)
      {
         echo "<option value='{$i}'";
         if($i == $showRating) echo " selected";
         echo ">" . ($i == 1 ? dgettext("album", "all") : "{$i}+");
      }
      echo "</select>";
   }

   displayFooter();
   echo "</table></td><td width='50%'></td></tr>";
   echo "</table></div></form>";
   echo "</body></html>";

   // Has the captions file changed?
   if((is_null($forceCaptionWrite) && $writeCaptions) || $forceCaptionWrite === true)
   {
      $origDir = $iniFile->filename;
      $iniFile->filename = $writeCaptionDir;
      $iniFile->writeFile();
      $iniFile->filename = $origDir;
   }
}

function handleFile($file, $photo, $colspan, $rowspan, $width, $height)
{
   global $albumAlias, $albumName, $albumConfig, $editMode;
   static $showID = null;

   if(!isset($_GET['refer']))
   {
      $_GET['refer'] = "";
      $showID = "next";
   }

   $caption = isset($photo['caption']) ? $photo['caption'] : $file;
   $alt = isset($photo['alt']) ? $photo['alt'] : "";

   // Is it another subalbum?
   if(isset($photo['album']))
   {
      $childInfo = new IniFile("{$albumName}/{$file}/{$albumConfig['infoFile']}");
      $childCount = count($childInfo->getSections());
      if($childInfo->sectionExists("Album"))
         $childCount--;

      if(isset($albumConfig['albumPrefix']) && !$editMode)
         $caption = $albumConfig['albumPrefix'] . $caption;

      if($childCount > 0 && !$editMode && isset($albumConfig['showCount']) && $albumConfig['showCount'])
         $caption .=" <br><span style='font-size: smaller'>" . sprintf(_("(%d images)"), $childCount) ."</span>";

      if(!isset($albumConfig['staticLevel']))
      {
         if(!is_dir("{$albumName}/{$file}/thumbs"))
            mkdir("{$albumName}/{$file}/thumbs", 0700);

         $createThumb = !file_exists("{$albumName}/{$file}/thumbs/album.jpg");

         if(!$createThumb)
         {
            $statThumb = stat("{$albumName}/{$file}/thumbs/album.jpg");
            $statOrig = stat("{$albumName}/{$file}");
            $createThumb = ($statThumb['mtime'] < $statOrig['mtime']);
         }

         if($createThumb)
         {
            $rating = ($albumConfig['ratingAction'] & RATING_SIZES) ? (isset($photo['rating']) ? $photo['rating'] : 2) : 0;
            createAlbumThumb("{$albumName}/{$file}", "{$albumName}/{$file}/thumbs", $rating);
         }
      }

      $dirName = dirname($file);
      $rating = isset($photo['rating']) ? $photo['rating'] : ($albumConfig['ratingAction'] & RATING_SIZES ? 2 : 0);

      displayImage($albumAlias . ($dirName == "." ? "" : "/$dirName"), $file, $caption, "", $width, $height, 0, $colspan, $rowspan, false, $showID, false, $rating);
   }
   // Or is it an image file
   else if($file != 'Album')
      displayImage($albumAlias, $file, $caption, $alt, $width, $height, 0, $colspan, $rowspan, true, $showID, isset($photo['edit']), isset($photo['rating']) ? $photo['rating'] : 0);

   if(isset($_GET['refer']) && $file == $_GET['refer'])
      $showID = "next";
   else if($showID != null)
      $showID = null;
}

function displayRegularGrid($files, $iniFile)
{
   global $albumConfig, $showRating;

   echo "<tr class='albumrow'>";

   $rowCount = 0;
   $panoramas = array();
   while(count($files) || count($panoramas))
   {
      $panoFits = $rowCount + 2 <= $albumConfig['numCols'];

      if(count($panoramas) && ($panoFits || !count($files)))
         $file = array_shift($panoramas);
      else
      {
         $file = array_shift($files);
         if($iniFile->valueExists($file, "panorama") && !$panoFits)
         {
            $panoramas[] = $file;
            unset($file);
         }
         else if($file == 'Album')
            unset($file);
      }

      if(isset($file))
      {
         $photo = $iniFile->getSection($file);
         $colspan = isset($photo['panorama']) ? 2 : 1;

         if(isset($photo['album']) || $showRating == 1 || (isset($photo['rating']) && $photo['rating'] >= $showRating))
         {
            handleFile($file, $photo, $colspan, 1, $colspan > 1 ? 310 : 133, 100);
            $rowCount += $colspan;
         }

         if($rowCount >= $albumConfig['numCols'])
         {
            echo "</tr><tr class='albumrow'>";
            $rowCount = 0;
         }
      }
   }

   echo "</tr>";
}

function hasRoom($grid, $row, $x, $sizeX, $sizeY)
{
   global $albumConfig;

   if($x + $sizeX > $albumConfig['numCols'])
      return false;

   for($ix = 0; $ix < $sizeX; $ix++)
      for($iy = 0; $iy < $sizeY; $iy++)
         if(isset($grid[$row + $iy][$x + $ix]) && $grid[$row + $iy][$x + $ix] !== true)
            return false;

   return true;
}

function displayIrregularGrid($files, $iniFile)
{
   global $albumConfig;

   // Working grid.
   //    [] == true: empty hole
   //    [] == string: thumbnail placed in hole
   //    [] == false: hole is used for larger thumbs
   $grid = array();
   $grid[0] = array_fill(0, $albumConfig['numCols'], true);

   // Place images
   foreach($files as $file)
   {
      if($file == 'Album') continue;

      $photo = $iniFile->getSection($file);
      $sizeX = $sizeY = isset($photo['rating']) ? $photo['rating'] : ($photo['album'] ? 2 : 1);
      if(isset($photo['panorama']))
         $sizeX *= 2;

      $row = 0; $rowCount = count($grid);
      do
      {
         for($x = 0; $x < $albumConfig['numCols']; $x++)
         {
            $filePlaced = hasRoom($grid, $row, $x, $sizeX, $sizeY);

            if($filePlaced)
            {
               for($ix = 0; $ix < $sizeX; $ix++)
                  for($iy = 0; $iy < $sizeY; $iy++)
                     $grid[$row + $iy][$x + $ix] = false;
               $grid[$row][$x] = $file;

               break;
            }
         }

         $row++;
      }
      while(!$filePlaced);
   }

   $rowCount = count($grid);
   $rowHeight = $albumConfig['thumbSizes'][0][2] + 15;      // arbitrary?
   for($row = 0; $row < $rowCount; $row++)
   {
      echo "<tr class='albumrow' height='{$rowHeight}'>";

      $cells = 0;
      for($x = 0; $x < $albumConfig['numCols']; $x++)
      {
         if(isset($grid[$row][$x]) && is_string($grid[$row][$x]))
         {
            $file = $grid[$row][$x];
            $photo = $iniFile->getSection($file);
            $size = isset($photo['rating']) ? $photo['rating'] : ($photo['album'] ? 2 : 1);

            handleFile($file, $photo,
                       $size * (isset($photo['panorama']) ? 2 : 1), $size,
                       $albumConfig['thumbSizes'][$size-1][isset($photo['panorama'])],
                       $albumConfig['thumbSizes'][$size-1][2]);
         }
         if(isset($grid[$row][$x]) && $grid[$row][$x] !== true)
            $cells++;
         else
            echo "<td></td>";
      }

//      for(; $cells < $albumConfig['numCols']; $cells++)
//         echo "<td></td>";

      echo "</tr>";
   }
}

// Display an HTML page for a single image

function displayImagePage($albumAlias, $fullImage, $size, $iniFile)
{
   global $albumConfig, $albumName;

   // Determine image size
   $sizes = getimagesize($fullImage);
   $newSize = $size;
   switch($size)
   {
   case 1:
      if(($sizes[0] / $sizes[1] > 1) || $albumConfig['mediumStrict'])   // Landscape
         $scale = max($sizes[0] / $albumConfig['mWidth'], $sizes[1] / $albumConfig['mHeight']);
      else                                                              // Portrait
         $scale = max($sizes[1] / $albumConfig['mWidth'], $sizes[0] / $albumConfig['mHeight']);

      if($scale > 1)
      {
         if($sizes[0] / $sizes[1] >= 2)                                 // Wide panorama
            $scale /= 2;

         $w = round($sizes[0] / $scale);
         $h = round($sizes[1] / $scale);
         break;
      }
      else
         $newSize = 2;
      // note: intentional fallthru when image is smaller than medium size
   case 2:
      $w = $sizes[0];
      $h = $sizes[1];
      break;
   }

   $base = basename($fullImage);
   if($iniFile->sectionExists($base))
   {
      $photo = $iniFile->getSection($base);
      $caption = isset($photo['caption']) ? $photo['caption'] : sprintf(dgettext("album", "Photo %s"), $base);
      $alt = isset($photo['alt']) ? $photo['alt'] : "";
   }
   else
   {
      $caption = $base;
      $alt = "";
   }
   displayHeader($albumConfig['showTitle'] ?  sprintf(dgettext("album", "%s album"), basename($albumName)) : "");
   displayPrevNext(true, $albumAlias, $base, $iniFile, false);

   echo "<div style='text-align: center'><table border='0' cellspacing='0' cellpadding='0' class='albumtable'>";
   echo "<tr class='albumrow'>";
   displayImage($albumAlias, $base, $caption, $alt, $w, $h, $newSize, 3);
   echo "</tr>";
   displayFooter();
   echo "</table></div></form></body></html>";
}


// Find four image files to use for album thumbnail

function find4Files($dir, $files)
{
   global $albumConfig;

   $h = @opendir($dir);
   while(($f = @readdir($h)) && count($files) < 4)
   {
      if(is_dir("{$dir}/{$f}") && $f != "thumbs" && $f[0] != ".")
         $files = find4Files("{$dir}/{$f}", $files);
      else if(in_array(strtolower(substr($f, strlen($f) - 3)), $albumConfig['imgSuffix']))
         $files[] = "{$dir}/{$f}";
   }
   @closedir($handle);

   return $files;
}

// Create a thumbnail for an album, by finding four images first

function createAlbumThumb($src, $dst, $rating)
{
   global $albumConfig;

   $thumbs = find4Files($src, array());

   $t = "";
   for($c = 0; $c < count($thumbs); $c++)
      $t .= "'{$thumbs[$c]}' ";
   for(; $c < 4; $c++)
      $t .= "'" . dirname(__FILE__) . "/images/blank.gif' ";

   if($rating)
   {
      $w = round($albumConfig['thumbSizes'][$rating-1][0] / 2) - 2;
      $h = round($albumConfig['thumbSizes'][$rating-1][2] / 2) - 1;
   }
   else
   {
      $w = 64;
      $h = 49;
   }

   // This is not perfect: we *should* first create the 4 properly cropped thumbnails, and then combine
   exec(PATH_MONTAGE . " -geometry {$w}!x{$h}!+1+1 -label \"\" -tile 2x2 $t '{$dst}/album.jpg'");
}

// Create a directory, including all parents if necessary

function mkdirRecursive($dir)
{
   if(!is_dir($dir) && $dir != ".")
   {
      mkdirRecursive(dirname($dir));
      mkdir($dir);
   }
}
?>
