<?php
   // Allowed arguments:
   //
   // $_GET['album']       path of directory to show album for, or album alias
   //                      (when used as e-pa plugin, $menuParams['albumPath'] can be used too)
   // $_GET['image']       optional name of file in album to show
   // $_GET['size']        for images: size of image to show (see image.php)
   // $_GET['cols']        number of columns in thumbnail view
   // $_GET['title']       if set to 'no', no titles will be shown

   session_start();

   include_once("album.config.php");
   include_once("album.inc.php");
   include_once("inifile.php");

   if(isset($_POST['showRating']))
   {
      if($albumConfig['ratingAction'] & RATING_SELECTOR)
         setcookie("albumRating", $_POST['showRating']);
      $showRating = $_POST['showRating'];
   }
   else if(!isset($_COOKIE['albumRating']))
   {
      if($albumConfig['ratingAction'] & RATING_SELECTOR)
         setcookie("albumRating", 1);
      $showRating = 1;
   }
   else
      $showRating = $_COOKIE['albumRating'];

   // Do we want edit mode?
   if(isset($_SESSION['epa']['User']['Keys']))
      $editMode =  in_array($_SESSION['epa']['Admin']['KeyName'], $_SESSION['epa']['User']['Keys']);
   else if(isset($albumConfig['editCode']))
      $editMode = isset($_GET['edit']) && $_GET['edit'] == $albumConfig['editCode'];

   // What album to use?
   if(isset($_GET['album']))
      $albumAlias = urldecode($_GET['album']);
   else if(isset($menuParams))
      $albumAlias = $menuParams['albumPath'];

   // Check whether we should expand the album alias
   if(isset($albumConfig['aliasFile']) && isset($albumAlias))
   {
      if($albumConfig['aliasesOnly'] || !is_dir($albumAlias))
      {
         $aliasFile = new Inifile($albumConfig['aliasFile']);

         $key = explode("/", $albumAlias);

         if($aliasFile->valueExists('aliases', $key[0]))
            $albumName = $aliasFile->getValue('aliases', $key[0]) . "/" . join("/", array_slice($key,1));
         else
            unset($albumAlias);
      }
      else
         $albumName = $albumAlias;
   }
   else
      $albumName = $albumAlias;

   if($albumName[strlen($albumName)-1] != "/")
      $albumName .= "/";

   // If the alias and name are the same and relative, prepend our own location
   if(strpos($albumName, $albumAlias) === 0 && $albumName[0] != "/")
      $albumName = dirname(__FILE__) . "/{$albumName}";
   
   // Get the name of the image or subalbum to display
   if(isset($_GET['image']))
   {
      $image = urldecode($_GET['image']);
      $fullImage = "{$albumName}{$image}";
   }
   else
      $fullImage = $image = $albumName;
   
   // Which size images to display?
   $size = isset($_GET['size']) ? $_GET['size'] : 0;

   // For e-pa, bind text translations
   if(isset($_SESSION['epa']))
      bindtextdomain("album", dirname(__FILE__) . "/locale");

   // Do we have a valid album, and do we need to display a subalbum?
   if(isset($albumAlias) && is_dir($fullImage))
   {
      $iniFile = new IniFile("{$fullImage}/{$albumConfig['infoFile']}");

      if($iniFile->valueExists("Album", "ratingAction"))
         $albumConfig['ratingAction'] = $iniFile->getValue("Album", "ratingAction");
      if($iniFile->valueExists("Album", "numCols"))
         $albumConfig['numCols'] = $iniFile->getValue("Album", "numCols");

      // Propagate a subfolder to the album alias
      if(isset($_GET['image']))
      {
         $albumAlias .= "/{$_GET['image']}";
         $albumName .= $_GET['image'];
      }

      displayAlbum($iniFile, $albumAlias, $albumName, true, $iniFile->filename);
   }
   // Display a single image
   else if(is_file($fullImage))
   {
      $iniFile = new IniFile("{$albumName}/{$albumConfig['infoFile']}");
      displayImagePage($albumAlias, $fullImage, $size, $iniFile);
   }
   else
   {
      displayHeader(dgettext("album", "No images in this album."));
      echo "</form></body></html>";

   }
?>
