<?php

function createThumb($image, $size, $rating)
{
   $sizes = getimagesize($image);

   if($size == 0)
   {
      include_once("album.config.php");

      if($rating)
      {
         $w = $albumConfig['thumbSizes'][$rating-1][$sizes[0] / $sizes[1] >= 2];
         $h = $albumConfig['thumbSizes'][$rating-1][2];
      }
      else
      {
         // For panorama photos, make twice-as-wide thumbnail
         $w = ($sizes[0] / $sizes[1] >= 2) ? 310 : 133;
         $h = 100;
      }

      exec(PATH_THUMB ." -crop -geom {$w}x{$h} -type jpg -dir thumbs '" . addslashes($image) . "'");
   }
   else
   {
      include_once("album.config.php");

      if(($sizes[0] / $sizes[1] > 1) || $albumConfig['mediumStrict'])   // Landscape
         $scale = max($sizes[0] / $albumConfig['mWidth'], $sizes[1] / $albumConfig['mHeight']);
      else
         $scale = max($sizes[1] / $albumConfig['mWidth'], $sizes[0] / $albumConfig['mHeight']);

      // If smaller than medium size
      if($scale < 1)
         $imageName = $image;
      else
      {
         if($sizes[0] / $sizes[1] >= 2)                                // wide panorama
            $scale /= 2;

         $w = round($sizes[0] / $scale);
         $h = round($sizes[1] / $scale);

         exec(PATH_THUMB . " -geom {$w}x{$h} -type jpg -dir thumbs/medium '" . addslashes($image) . "'");
      }
   }
}
?>
