<?php
   // Full filename of image to display. The extension should be present in the
   // $mimeTypes array defined below
   $image = $_GET['image'];

   // Size of image to display:
   //  0: thumbnail, create if not available yet
   //  1: medium size (size from album.config.php), create if not available yet
   //  2: full size image as-is
   //  3: thumbnail from EXIF header fi available, else default to size=0
   $size = $_GET['size'];
   $rating=$_GET['rating'];

   $dir = dirname($image);
   $p = strrpos($image, ".");
   $name = substr($image, 0, $p);

   $mimeTypes = array(
      "jpg"  => "jpeg",
      "jpeg" => "jpeg",
      "gif"  => "gif",
      "png"  => "png"
   );

   switch($size)
   {
   case 0:
      $imageName = $dir . "/thumbs/" . basename($name) . ".jpg";
      $ext = "jpg";
      break;
   case 1:
      $imageName = $dir . "/thumbs/medium/" . basename($name) . ".jpg";
      $ext = "jpg";
      break;
   default:
      $imageName = $image;
      $ext = strtolower(substr($image, $p + 1));
      break;
   }

   if(!array_key_exists($ext, $mimeTypes))
      return;

   if($size == 3)       // special case: use embedded EXIF thumbnail
   {
      $image = exif_thumbnail($imageName, $width, $height, $type);

      if($image !== false)
      {
         header("Content-type: " . image_type_to_mime_type($type));
         echo $image;
         exit;
      }
      else
         $size = 0;     // fallthrough!
   }

   header('Content-type: image/' . $mimeTypes[$ext]);

   if($size < 2)
   {
      $createThumb = !file_exists($imageName);

      if(!$createThumb)
      {
         $statThumb = stat($imageName);
         $statOrig = stat($image);
         $createThumb = ($statThumb['mtime'] < $statOrig['mtime']);
      }

      if($createThumb)
      {
         include("image.inc.php");
         createThumb($image, $size, $rating);
      }
   }

   if(!@readfile($imageName))
      readfile(dirname($_SERVER['SCRIPT_FILENAME']) . "/images/album.gif");
?>
