// Find out if it is Netscape 5+
var netscape = (document.layers) ? 1 : 0;
var goodIE = (document.all) ? 1 : 0;
var netscape6 = (document.getElementById && !document.all) ? 1 : 0;

// Only for IE5+
var hspc = getRealLeft(document.getElementById("i_mainImg"));
var vspc = getRealTop(document.getElementById("i_mainImg"));
var iWidth  = document.getElementById("i_mainImg").width;
var iHeight = document.getElementById("i_mainImg").height;

// Global vars to save mouse position
var mouseX = 0;
var mouseY = 0;
var x1 = 0;
var y1 = 0;
var x2 = 0;
var y2 = 0;
var firstx = 0;
var firsty = 0;
var secondx = 0;
var secondy = 0;
var zleft = 0;
var zright = 0;
var ztop = 0;
var zbottom = 0;
var mapX = 0;
var mapY = 0;
var dragging = false;

// Layers names
var toplayer = "zBoxTop";
var leftlayer = "zBoxLeft";
var bottomlayer = "zBoxBottom";
var rightlayer = "zBoxRight";

// Initialize event handlers
setClipBoxSettings();

// Build the rubber band rectangle elements
createLayer("zBoxTop", hspc, vspc, iWidth, iHeight, false, '<img name="zImgTop" border="1">');
createLayer("zBoxLeft", hspc, vspc, iWidth, iHeight, false, '<img name="zImgLeft" border="1">');
createLayer("zBoxBottom", hspc, vspc, iWidth, iHeight, false, '<img name="zImgBottom" border="1">');
createLayer("zBoxRight", hspc, vspc, iWidth, iHeight, false, '<img name="zImgRight" border="1">');

// Clip box color
setLayerBackgroundColor("zBoxTop",   "white");
setLayerBackgroundColor("zBoxLeft",  "white");
setLayerBackgroundColor("zBoxRight", "white");
setLayerBackgroundColor("zBoxBottom","white");

// Create a DHTML layer
function createLayer(name, left, top, width, height, visible, content)
{
   var layer, str;
   if(netscape)
   {
      str = '<layer id="' + name + '" left=' + left + ' top=' + top +
            ' width=' + width + ' height=' + height +
            ' visibility=' + (visible ? '"show"' : '"hide"') + '>';
      document.writeln(str);
      document.writeln(content);
      document.writeln('</layer>');
      layer = getLayer(name);
      layer.width = width;
      layer.height = height;
   }
   else if(goodIE || netscape6)
   {
      str = '<div id="' + name +
            '" style="position:absolute; overflow:none; left:' + left +
            'px; top:' + top + 'px; width:' + width + 'px; height:' + height +
            'px;' + ' visibility:' + (visible ? 'visible;' : 'hidden;') +  '">';
      document.writeln(str);
      document.writeln(content);
      document.writeln('</div>');
   }
   else
      return null;
   clipLayer(name, 0, 0, width, height);
}

// Get the layer object called "name"
function getLayer(name)
{
   if(netscape)
      return document.layers[name];
   else if(goodIE)
   {
      if(eval('document.all.' + name) != null)
      {
         layer = eval('document.all.' + name + '.style');
         return layer;
      }
      else
         return null;
   }
   else if(netscape6)
   {
      if(eval('document.getElementById("' + name + '")') != null)
      {
         layer = eval('document.getElementById("' + name + '").style');
         return layer;
      }
      else
         return null;
   }
   else
      return null;
}

// Set layer background color
function setLayerBackgroundColor(name, color)
{
   var layer = getLayer(name);
   if(layer != null)
   {
      if(netscape)
         layer.bgColor = color;
      else if(goodIE || netscape6)
         layer.backgroundColor = color;
   }
}

// Toggle layer to visible
function showLayer(name)
{
   var layer = getLayer(name);
   if(layer != null)
   {
      if(netscape)
         layer.visibility = "show";
      else if(goodIE || netscape6)
         layer.visibility = "visible";
   }
}

// Clip layer display to clipleft, cliptip, clipright, clipbottom
function clipLayer(name, clipleft, cliptop, clipright, clipbottom)
{
   var layer = getLayer(name);
   if(layer != null)
   {
      if(netscape)
      {
         layer.clip.left   = clipleft;
         layer.clip.top    = cliptop;
         layer.clip.right  = clipright;
         layer.clip.bottom = clipbottom;
      }
      else if(goodIE)
         layer.clip = 'rect(' + cliptop + ' ' +  clipright + ' ' + clipbottom + ' ' + clipleft + ')';
      else if(netscape6)
         layer.clip = 'rect(' + cliptop + 'px ' + clipright + 'px ' + clipbottom + 'px ' + clipleft + 'px)';
   }
}

function setClipBoxSettings()
{
   // Set up event capture for mouse movement
   if(netscape)
   {
      document.captureEvents(Event.MOUSEMOVE);
      document.captureEvents(Event.MOUSEDOWN);
      document.captureEvents(Event.MOUSEUP);
      document.captureEvents(Event.RESIZE);
   }

   document.onmousemove = mouseMoveHandler;
   document.onmousedown = mouseDownHandler;
   document.onmouseup = mouseUpHandler;
   window.onresize = resizeHandler;
}

function resizeHandler()
{
   if(netscape || netscape6)
      location.reload();
}

function mouseUpHandler(e)
{
   if(dragging)
   {
      mouseX = Math.min(Math.max(mouseX, 0), iWidth);
      mouseY = Math.min(Math.max(mouseY, 0), iHeight);
      mouseDownHandler(e);
   }
}

function mouseDownHandler(e)
{
   getImageXY(e);
   if(!dragging && insideMap())
   {
      statrClipBox(e);
      return false;
   }
   else if(dragging)
   {
      mouseMoveHandler(e);
      stopClipBox(e);
   }
   return true;
}

function getImageXY(e)
{
   if(netscape || netscape6)
   {
      mouseX = e.pageX;
      mouseY = e.pageY;
   }
   else if(goodIE)
   {
      mouseX = event.clientX + document.body.scrollLeft;
      mouseY = event.clientY + document.body.scrollTop;
   }
   else
      mouseX = mouseY = 0;

   // Subtract offsets from page left and top
   mouseX = mouseX - hspc;
   mouseY = mouseY - vspc;
}

function mouseMoveHandler(e)
{
   window.status = "";
   getImageXY(e);

   if(dragging)
   {
      x2 = mouseX = Math.min(Math.max(mouseX, 0), iWidth);
      y2 = mouseY = Math.min(Math.max(mouseY, 0), iHeight);
      setClip();
      return false;
   }
   else
      return true;
}

function insideMap()
{
  return ((mouseX >= 0) && (mouseX < iWidth) && (mouseY >= 0) && (mouseY < iHeight));
}

// Start clip... box displayed
function statrClipBox(e)
{
   getImageXY(e);
   // Keep it within the image
   if(!dragging)
   {
      // capture values
      firstx = x1 = mouseX;
      firsty = y1 = mouseY;
      x2 = x1 + 1;
      y2 = y1 + 1;

      clipLayer(toplayer, x1, y1, x2, y2);
      clipLayer(leftlayer, x1, y1, x2, y2);
      clipLayer(rightlayer, x1, y1, x2, y2);
      clipLayer(bottomlayer, x1, y1, x2, y2);
      showLayer(toplayer);
      showLayer(leftlayer);
      showLayer(rightlayer);
      showLayer(bottomlayer);
      dragging = true;
   }
   else
      stopClipBox(e);

   return false;
}

// Stop clip
function stopClipBox(e)
{
   dragging = false;

   secondx = x2;
   secondy = y2;

   document.form.clipLeft.value   = Math.min(firstx, secondx);
   document.form.clipTop.value    = Math.min(firsty, secondy);
   document.form.clipRight.value  = Math.max(firstx, secondx);
   document.form.clipBottom.value = Math.max(firsty, secondy);

   return false;
}

// clip zoom box layer to mouse coords
function setClip()
{
   zright  = Math.max(x1, x2);
   zleft   = Math.min(x1, x2);
   zbottom = Math.max(y1, y2);
   ztop    = Math.min(y1, y2);

   if((x1 != x2) && (y1 != y2))
   {
      var ovBoxSize = 1;
      clipLayer(toplayer, zleft, ztop, zright, ztop + ovBoxSize);
      clipLayer(leftlayer, zleft, ztop, zleft + ovBoxSize, zbottom);
      clipLayer(rightlayer, zright - ovBoxSize, ztop, zright, zbottom);
      clipLayer(bottomlayer, zleft, zbottom - ovBoxSize, zright, zbottom);
   }
}

function getRealLeft(el)
{
   xPos = el.offsetLeft;
   tempEl = el.offsetParent;
   while (tempEl != null) {
       xPos += tempEl.offsetLeft;
       tempEl = tempEl.offsetParent;
   }
   return xPos;
}

function getRealTop(el)
{
   yPos = el.offsetTop;
   tempEl = el.offsetParent;
   while (tempEl != null) {
       yPos += tempEl.offsetTop;
       tempEl = tempEl.offsetParent;
   }
   return yPos;
}

