<?php
   include_once("album.inc.php");
   include_once("album.config.php");

   // Don't show the slideshow checkbox
   unset($albumConfig['slideShow']);

   function getEXIFString($file)
   {
      $exif = exif_read_data($file, "EXIF");

      return $exif === false ? "" :
         "Filename: " . $exif['FileName'] . " (" . $exif['FileSize'] . " bytes)" .
         "\nDate: " . $exif['DateTime'] .
         "\nSize: " . $exif['COMPUTED']['Width'] . " x " . $exif['COMPUTED']['Height'] .
         "\nAperture: " . $exif['COMPUTED']['ApertureFNumber'] .
         "\nExposuretime: " . $exif['ExposureTime'] .
         "\nISO setting: " . $exif['ISOSpeedRatings'] .
         "\nFocal length: " . $exif['FocalLength']. "mm" .
         "\nFocal length (35mm equiv.): " . $exif['FocalLengthIn35mmFilm']. "mm";
   }

   function getImageShowSize($file)
   {
      global $albumConfig;

      $sizes = getimagesize($file);

      if(($sizes[0] / $sizes[1] > 1) || $albumConfig['mediumStrict'])   // Landscape
         $scale = max($sizes[0] / $albumConfig['mimgsWidth'], $sizes[1] / $albumConfig['mimgsHeight']);
      else
         $scale = max($sizes[1] / $albumConfig['mimgsWidth'], $sizes[0] / $albumConfig['mimgsHeight']);

      // If smaller than maximum size
      if($scale < 1)
         return $sizes;
      else
         return array(round($sizes[0] / $scale), round($sizes[1] / $scale));
   }

   function getDirs($dir, $prefix, &$targets)
   {
      $handle = @opendir($dir);
      while($file = @readdir($handle))
      {
         if(is_dir("{$dir}/{$file}") && $file[0] != "." && $file != "thumbs")
         {
            $targets[] = "{$prefix}{$file}";
            getDirs("{$dir}/{$file}", "{$prefix}{$file}/", $targets);
         }
      }
      @closedir($handle);
   }

   function directorySelector($label, $name, $values, $value = "", $selectAttrs = "")
   {
      echo "$label <select name='{$name}' $selectAttrs";
      if(!count($values))
         echo " disabled";

      echo "><option value=''>(select folder)";
      if(count($values))
      {
         while(list($k,$v) = each($values))
         {
            echo "<option";
            if($value != "" && $v == $value)
               echo " selected";
            echo ">$v";
         }
         echo "</select>";
      }
   }
   function directoryInput1($name)
   {
      $value = (isset($_POST[$name]) && $_POST[$name] == "{$name}1") ? $_POST["{$name}Dir1"] : $_POST["{$name}Dir2"];

      if(!isset($_POST["{$name}Dir1"]))
         $_POST['{$name}Dir1'] = "(type name of folder)";

      echo "<input type='checkbox' class='checkbox' name='{$name}' value='{$name}1' onclick='form.{$name}[1].checked = false'";
      if(isset($_POST["{$name}Dir1"]) && $value == $_POST["{$name}Dir1"])
         echo " checked";
      echo ">";
      echo "<input type='text' name='{$name}Dir1' value='".$_POST["{$name}Dir1"]."' size='90' onclick='if(this.value.charAt(0) == \"(\") this.select(); form.{$name}[0].checked = true; form.{$name}[1].checked = false'>";
   }

   function directoryInput2($name, $baseDir = null, $showLabel = true)
   {
      $value = (isset($_POST[$name]) && $_POST[$name] == "{$name}1") ? $_POST["{$name}Dir1"] : $_POST["{$name}Dir2"];
      echo "<input type='checkbox' class='checkbox' name='{$name}' value='{$name}2' onclick='form.{$name}[0].checked = false'";
      if(isset($_POST["{$name}Dir2"]) && $value != "" && $value == $_POST["{$name}Dir2"])
         echo " checked";
      echo ">";
      $onchange = "onchange='form.{$name}[0].checked = false; form.{$name}[1].checked = true' ";

      $dirs = array();
      if(!is_null($baseDir))
         getDirs($baseDir, "", $dirs);

      directorySelector($showLabel ? $baseDir : "", "{$name}Dir2", $dirs, $_POST["{$name}Dir2"], $onchange . (count($dirs) ? "" : " disabled"));
   }

   function showSrcDstDirs()
   {
      global $albumConfig;

      echo "<tr><td><b>Directory containing new images:</b></td><td>";
      directoryInput1("src");
      echo "</td></tr><tr><td align='right'>or</td><td>";
      directoryInput2("src", isset($albumConfig['srcBase']) ? $albumConfig['srcBase'] : null);
      echo "</td></tr>";

      $value = (isset($_POST['dst']) && $_POST['dst'] == "dst1") ? $_POST['dstDir1'] : $_POST['dstDir2'];
      echo "<tr><td><b>Directory to copy images to:</b></td><td>";
      directoryInput1("dst");
      echo "</td></tr><tr><td align='right'>or</td><td>";
      directoryInput2("dst", isset($albumConfig['dstBase']) ? $albumConfig['dstBase'] : null);
      echo "</td></tr>";

      if(!isset($_POST['startImg']))
         $_POST['startImg'] = basename($_POST['img']);

      echo "<tr><td>Start at image file:</td><td><input type='text' name='startImg' size='90' value='{$_POST['startImg']}'></td></tr>";
      echo "<tr><td></td><td><input type='submit' class='button' value='continue'></td></tr>";
   }

   if(isset($_GET['preview']))
   {
      displayHeader(basename($_GET['preview']), false);
      echo "<div style='text-align: center'><table border='0' class='albumtable'>";
      echo "<td class='albumcell' valign='top'>";
      $size = getImageShowSize($_GET['preview']);
      displayImageTag($_GET['preview'], getEXIFString($_GET['preview']), $size[0], $size[1], 2);
      echo "</td>";
      displayFooter();
      echo "</table></div></form></body></html>";
      return;
   }
   else if(!isset($_POST['src']) || !isset($_POST['dst']) || (isset($_POST['cmd']) && $_POST['cmd'] == "next folder"))
   {
      displayHeader("Managing new images");
      echo "<div style='text-align: center'><table border='0' class='albumtable'>";
      showSrcDstDirs();
      displayFooter();
      echo "</table></div></form></body></html>";
      return;
   }
   else
   {
      $srcDir = $_POST['src'] == "src1" ? $_POST['srcDir1'] : ($albumConfig['srcBase'] . $_POST['srcDir2']);
      $dstDir = $_POST['dst'] == "dst1" ? $_POST['dstDir1'] : ($albumConfig['dstBase'] . $_POST['dstDir2']);
   }

   // From here on: source and destination directories are known

   // Get all files in the source directory
   $files = array();
   $handle = @opendir($srcDir);
   while($file = @readdir($handle))
   {
      $dotpos = strrpos($file, ".");
      // If image...
      if(in_array(strtolower(substr($file, $dotpos+1)), $albumConfig['imgSuffix']))
         $files[] = "{$srcDir}/{$file}";
   }
   @closedir($handle);
   $fileCount = count($files);

   // Process any requested operations on the previous image
   if(isset($_POST['cmd']) && $_POST['cmd'] == "do it")
   {
      include("inifile.php");

      // $_POST['move'] => move1, move2
      //    $_POST['moveDir1'], $_POST['moveDir2']
      if(isset($_POST['move']))
      {
         if($_POST['move'] == "move1")
         {
            mkdirRecursive("{$dstDir}/{$_POST['moveDir1']}");

            $moveTo = "{$dstDir}/{$_POST['moveDir1']}";
            $targets[] = $_POST['moveDir1'];
         }
         else if($_POST['move'] == "move2")
            $moveTo = "{$dstDir}/{$_POST['moveDir2']}";
      }
      else
         $moveTo = $dstDir;

      if(!is_dir($moveTo))
         mkdir($moveTo);

      // $_POST['description']
      $iniFile = new IniFile("{$moveTo}/{$albumConfig['infoFile']}");
      $iniFile->setValue(basename($_POST['img']), "caption", $_POST['description']);

      // $_POST['mark'] => print, delete, edit
      if(isset($_POST['mark']))
         foreach($_POST['mark'] as $mark)
            $iniFile->setValue(basename($_POST['img']), $mark, "yes");

      if(isset($_POST['rating']) && $_POST['rating'] != '')
         $iniFile->setValue(basename($_POST['img']), "rating", $_POST['rating']);

      $iniFile->writeFile();

      $newImgFile = $moveTo . "/" . basename($_POST['img']);

      // Do we need top clip?
      $clip = ($_POST['clipLeft'] != $_POST['clipRight'] && $_POST['clipTop'] != $_POST['clipBottom']);
      if($clip)
      {
         // The crop is wrt the 1024x768 size
         $showSize = getImageShowSize($_POST['img']);

         $sizes = getimagesize($_POST['img']);

         $sx = $sizes[0] / $shownSize[0];
         $sy = $sizes[1] / $shownSize[1];

         $x = intval($_POST['clipLeft'] * $sx);
         $y = intval($_POST['clipTop'] * $sy);
         $w = intval(($_POST['clipRight'] - $_POST['clipLeft']) * $sx);
         $h = intval(($_POST['clipBottom'] - $_POST['clipTop']) * $sy);

         $clipCmd = "{$w}x{$h}+{$x}+{$y}";
      }

      $optimize = $albumConfig['optimizeOnCopy'] && (PATH_JPEGTRAN != "");

      // $_POST['rotate'] => 90, 180, 270
      if(isset($_POST['rotate']))
      {
         if($clip || PATH_JPEGTRAN == "")
            // rotate
            exec(PATH_CONVERT . " -crop $clipCmd -rotate {$_POST['rotate']} '{$_POST['img']}' '{$newImgFile}'");
         else
         {
            // we can do it lossless if no clip
            $opt = ($albumConfig['optimizeOnCopy'] ? " -optimize" : "");
            $optimize = false;
            exec(PATH_JPEGTRAN . $opt . " -rotate {$_POST['rotate']} -outfile '{$newImgFile}' '{$_POST['img']}'");
         }
      }
      // file should go to a different location
      else if(($srcDir != $dstDir) || isset($_POST['move']) || $clip)
      {
         if($clip)
            // just crop
            exec(PATH_CONVERT . " -crop $clipCmd '{$_POST['img']}' '{$newImgFile}'");
         else if($optimize)
         {
            $optimize = false;
            exec(PATH_JPEGTRAN . " -optimize -outfile '{$newImgFile}' '{$_POST['img']}'");
         }
         else
         {
            // copy
            copy($_POST['img'], $newImgFile);
         }
      }

      if($optimize)
      {
         exec(PATH_JPEGTRAN . " -optimize -outfile '{$newImgFile}.tmp' '{$_POST['img']}'");
         rename($newImgFile . ".tmp", $newImgFile);
      }
   }

   // Either use first file found, or the file following the file indicated by posted data
   if(isset($_POST['img']))
   {
      $imgIndex = array_search($_POST['img'], $files);
      if($imgIndex !== false)
      {
         if($_POST['direction'] < 0)
            $imgIndex = max(0, $imgIndex + $_POST['direction']);
         else
            $imgIndex = min($imgIndex + $_POST['direction'], $fileCount - 1);

         $imgFile = $files[$imgIndex];
      }
   }
   else if(count($files))
   {
      if(isset($_POST['startImg']))
      {
         $imgIndex = array_search("{$srcDir}/{$_POST['startImg']}", $files);
         $imgFile = $files[$imgIndex];
      }
      else
      {
         $imgFile = $files[0];
         $imgIndex = 0;
      }
   }

   $imgSize = getImageShowSize($imgFile);

   // Output a page
   displayHeader("Manage new images in {$srcDir}");
   echo "<div style='text-align: center'><table border='0' class='albumtable'>";

   if(isset($imgFile))
   {
      echo "<script>function goto(dir) { form.direction.value = dir; form.submit(); }";
      echo "function preview(img) { window.open(img, '', 'width=". ($imgSize[0] + 96) . ",height=" . ($imgSize[1] + 72) . ",status=no,menubar=no,resizable=yes,scrollbars=yes'); }</script>";

      echo "<tr class='albumrow'>";

      $numPreviews = 5;
      echo "<td width='170' align='center'>";
      if(isset($imgIndex) && $imgIndex > 0)
      {
         for($i = $imgIndex - $numPreviews; $i < $imgIndex; $i++)
         {
            if($i >= 0)
            {
               displayImageTag($files[$i], getEXIFString($files[$i]), 133, 100, 3);
               $diff = $i - $imgIndex;
               echo "<a href='javascript:preview(\"$PHP_SELF?preview={$files[$i]}\")'>[preview]</a> <a href='javascript:goto({$diff})'>[goto]</a>";
            }
         }
      }
      echo "</td>";

      echo "<td class='albumcell' valign=center>";
      displayImageTag($imgFile, getEXIFString($imgFile), $imgSize[0], $imgSize[1], 2, 1, "", true, "id=i_mainImg");
      echo "$imgFile</td>";

      echo "<td width='170' align='center'>";
      if(isset($imgIndex) && $imgIndex < $fileCount - 1)
      {
         for($i = $imgIndex + 1; $i <= $imgIndex + $numPreviews; $i++)
            if($i < $fileCount)
            {
               displayImageTag($files[$i], getEXIFString($files[$i]), 133, 100, 3);
               $diff = $i - $imgIndex;
               echo "<a href='javascript:preview(\"$PHP_SELF?preview={$files[$i]}\")'>[preview]</a><a href='javascript:goto({$diff})'>[goto]</a>";
            }
      }
      echo "</td>";

      echo "</tr>";

      echo "<tr class='albumrow'><table>";
      echo "<tr>";
      echo "<th width='100'>Description:</th><td><input type='text' name='description' value='" . basename($imgFile) . "' style='width: 100%' onclick='if(this.value.indexOf(\".jpg\") > 0) this.select()'></td>";
      echo "<th width='100'>Mark as:</th><td><input type='checkbox' class='checkbox' name='mark[] value='print'>print</td>";
      echo "<th width='100' nowrap>Rotate:</th><td><input type='radio' class='checkbox' name='rotate' value='270'>90 degrees counterclockwise</td>";
      echo "</tr>";

      echo "<tr><th width='100' nowrap>Subfolder:</th><td>";

      if(isset($_POST['move']) && $_POST['move'] == 'dir1')
         $_POST['moveDir2'] = $_POST['moveDir1'];

      unset($_POST['move']);
      $_POST['moveDir1'] = "(type name of new folder)";

      directoryInput1("move");

      echo "</td><td></td><td><input type='checkbox' class='checkbox' name='mark[]' value='delete'>delete</td>";
      echo "<td></td><td nowrap><input type='radio' class='checkbox' name='rotate' value='180'>180 degrees</td>";
      echo "</tr><tr><td></td><td>";

      directoryInput2("move", $dstDir, false);

      echo "</td><td></td><td><input type='checkbox' class='checkbox' name='mark[]' value='edit'>edit</td>";
      echo "<td></td><td nowrap><input type='radio' class='checkbox' name='rotate' value='90'>90 degrees clockwise</td>";
      echo "</tr>";

      echo "<tr>";
      echo "<td></td><td><input type='submit' class='button' name='cmd' value='do it'></td>";
      echo "<th width='100'>Rating:</th><td><select name='rating'><option value=''>none<option>1<option>2<option>3<option>4</select></td>";
      echo "</tr>";
      echo "<td></td><td><input type='submit' class='button' name='cmd' value='skip'>";
      echo "&nbsp;<input type='submit' class='button' name='cmd' value='next folder'></td></tr>";
      echo "</tr>";

      echo "<input name='img' type='hidden' value='{$imgFile}'>";
      echo "<input name='direction' type='hidden' value='1'>";
      echo "<input name='src' type='hidden' value='{$_POST['src']}'>";
      echo "<input name='srcDir1' type='hidden' value='{$_POST['srcDir1']}'>";
      echo "<input name='srcDir2' type='hidden' value='{$_POST['srcDir2']}'>";
      echo "<input name='dst' type='hidden' value='{$_POST['dst']}'>";
      echo "<input name='dstDir1' type='hidden' value='{$_POST['dstDir1']}'>";
      echo "<input name='dstDir2' type='hidden' value='{$_POST['dstDir2']}'>";

      echo "</table></tr>";

      echo "<script src=mimgs.js></script>";
      // Will hold clip area if any
      echo "<input type='hidden' name='clipLeft'>";
      echo "<input type='hidden' name='clipTop'>";
      echo "<input type='hidden' name='clipRight'>";
      echo "<input type='hidden' name='clipBottom'>";
   }
   else
   {
      echo "No (more) images.";
      showSrcDstDirs();
   }

   displayFooter();
   echo "</table></div></form></body></html>";
?>
